#!/bin/bash

set -e

if [[ "$#" -ne 4 ]]; then
  echo "Użycie: encrypt.sh <CMK_ID> <AWS_REGION> <INPUT_FILE> <OUTPUT_FILE>"
  exit
fi

CMK_ID="$1"
AWS_REGION="$2"
INPUT_FILE="$3"
OUTPUT_FILE="$4"

echo "Szyfrowanie pliku $INPUT_FILE za pomocą CMK $CMK_ID..."
ciphertext=$(aws kms encrypt \
  --key-id "$CMK_ID" \
  --region "$AWS_REGION" \
  --plaintext "fileb://$INPUT_FILE" \
  --output text \
  --query CiphertextBlob)

echo "Zapis danych do pliku $OUTPUT_FILE..."
echo "$ciphertext" > "$OUTPUT_FILE"

echo "Gotowe!"
